# History of Python

## What is Python?

<img src = "https://upload.wikimedia.org/wikipedia/commons/thumb/0/0a/Python.svg/1200px-Python.svg.png" width="300"/>
Python is a high level interpreted general purpose programming language. Python is a dynamically typed programming language.It supports many programming types: Structured, Object-oriented and Functional. Python is well known for the enormous library it has.

## Inventor of Python?

<a href = "https://en.wikipedia.org/wiki/Guido_van_Rossum">Guido van Rossum</a> started to work on Python in the late 1980s as a successor to the ABC programming language. The first version of Python was released on 1991, version:0.9.0
The latest version of Python(3.9.7) can be downloaded by clicking <a href = "https://www.python.org/ftp/python/3.9.7/python-3.9.7-amd64.exe">here</a>

## History

1. The implementation of Python started in December 1989 by Guido van Rossum at CWI in Netherland.
2. The first version of Python was published to alt.sources.
3. In 1994, Python 1.0 had libraries like lambda, map, reduce, filter.
4. Python 2.0 released with comprehensions and garbage collection systems.
5. Python 3.0 was released on December 3, 2008.
6. Python is influenced by 2 programming languages: ABC Programming Langugae and Modula-3
7. ABC programming language is said to be the predecessor of Python language, which was capable of Exception Handling and interfacing with the Amoeba Operating System.
8. Modula-3's main features are simplicity and safety while preserving the power of a systems-programming language.

## Name Python

Guido van Rossum was reading the script of a popular BBC comedy series "Monty Python's Flying Circus". It was late on-air 1970s.Van Rossum wanted to select a name which unique, sort, and little-bit mysterious. So he decided to select naming Python after the "Monty Python's Flying Circus" for their newly created programming language.The comedy series was creative and well random. It talks about everything. Thus it is slow and unpredictable, which made it very interesting.

## Use of Python

Python is a programming language which used in many spheres of life nowadays:

1. Machine Learning
2. Automation
3. Web Applications
4. Embedded systems
5. Data Analysis
6. Game Development

## Advantages of Python over other Programming Languages

1. <i>Interpreted</i>: Interpreter processes the source file at runtime, it reads the lines of code one by one and performs what is said. Python does not require that you compile your program before executing it. So, you do not have to invoke a compiler. Instead of running the compiler that helps turn source files into compiled class files, you simply run a .py file. Python byte code compilation is automatic and entirely implicit.

2. <i>High Level</i>: Python relies on easy-to-read structures that are later translated into a low-level language, the original code that is run on a computer’s central processing unit (CPU). A high-level language is intended to be used by a programmer and the written code is further interpreted into a low-level language. Like C++ or Java, before running, Python has to be processed. This enables Python’s portability — it can run on different kinds of computers with nearly no modifications.

3. <i>General Purpose</i>: This programming paradigm gives an overall orientation towards scripting and powerful code structuring. This object-oriented approach allows thinking of problems in terms of classes and objects. Then, objects are composed in such a way to make up complex computer programs. Beside the object-oriented programming, Python also supports a procedural paradigm. With OOP being only one of the options, you can make Python programming more advanced by going for an object-oriented programming approach. Developers can create reusable patterns of code thus curtailing redundancy in development projects.

### In general advantages of Python:

1. <i><b>Simplicity</b></i>: Python’s straightforward and simple syntax is something that makes beginners want to learn this scripting language. From some perspective, it may seem natural and pre-determined that Python can turn into the lingua franca of coding, manifesting all the rest of its opponents obsolete. Its code is easy to comprehend, share, and maintain. There is no verbosity and the language is easy to learn.

2. <i><b>A powerful toolbox</b></i>: Inherently, Python programs are text files containing instructions for the interpreter and are written in a text editor or IDE. Python also has a huge array of third-party packages, libraries, and frameworks that facilitate the development process. These optimization capabilities thus make Python great for large-scale projects.

2. <i><b>Development speed</b></i>: We mean business speed here and the time-to-market metric. Python is a dynamic scripting language, so it isn’t intended for writing applications from scratch but it’s primarily intended for plugging together components. Components are designed to be reusable while the interfaces between components and scripts are well-defined. It all accelerates the speed of software development with Python making the language highly concise and productive.

3. <i><b>Flexibility</b></i>: Although Python puts emphasis on code simplicity and readability rather than flexibility, the language still has it. Python is usable across different projects. It allows developers to choose between object-oriented and procedural programming modes. Python is flexible in data type, too. There are 5 of them: Number, String, List, Tuple, and Dictionary and every sub-data type corresponds to one of these root types. As a result, the exploratory data analysis becomes easier to conduct due to Python’s flexibility.

4. <i><b>Portability</b></i>: Python is designed to be portable. Its programs are supported on any modern computer OS. Owing to the high-level nature of the language, Python script is interpreted, so it can be written for further interpretation equally well on Linux, Windows, Mac OS, and UNIX without demanding for adjustments. Python programs also allow implementing portable GUIs.

5. <i><b>A strong community</b></i>: Python has a rapidly growing user base and actually is representative of what a strong community is. There are thousands of contributors to Python’s powerful toolbox — Pythonists. There are already almost 200,000 custom-built software packages user-uploaded to an online repository. All it implies that the great supportive community is both the reason for and the consequence of the language’s being in demand.



## Disadvantages of Python

1. Slow speed. Fixed using PyPy.

2. Python’s dynamism prevents catching semantic errors upfront.

3. Threading is less performant in Python than in other languages. 

4. Pyhton depends almost entirely on third party libraries.

## Conclusion and Summary

Talking about Python in the general sense, the language is very powerful in most of the study fields. It has a lot of packages prebuilt which makes our task easier. The code is like simple English, so not very hrd to write. Overall Python can be considered to be on the top of all other programming languages, except in some particular fields like App development or compiler design.
